// Copyright (c) Paul Agron
//
// Permission is hereby granted, free of charge, to any person
// obtaining a copy of this software and associated documentation
// files (the "Software"), to deal in the Software without
// restriction, including without limitation the rights to use,
// copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following
// conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
//
// If you use it, acknowledgement in an About Page or other appropriate place is required.
// For example, "Contains "KTUIKit" by Paul Agron" will do.


#pragma once

extern void _symbicLog(int level, int line, char* file, id obj, SEL sel, NSString *msg, ...);

// elog is same as elogDebug
#define elog(str, ...) {_symbicLog(0, __LINE__, __FILE__, self, _cmd, str, __VA_ARGS__);}
#define elogDebug(str, ...) {_symbicLog(0, __LINE__, __FILE__, self, _cmd, str, __VA_ARGS__);}
#define elogInfo(str, ...) {_symbicLog(1, __LINE__, __FILE__, self, _cmd, str, __VA_ARGS__);}
#define elogWarn(str, ...) {_symbicLog(2, __LINE__, __FILE__, self, _cmd, str, __VA_ARGS__);}
#define elogError(str, ...) {_symbicLog(3, __LINE__, __FILE__, self, _cmd, str, __VA_ARGS__);}


// SY stands for SymbicLog where every class will be prefixed with SY e.g. SYLogger


@protocol SYLoggerChannel
-(void)logMessage:(NSString*)msg
         fromFile:(NSString*)fileName 
       lineNumber:(NSUInteger)line
        forObject:(id)obj 
         selector:(SEL)sel
       threadName:(NSString*)threadName
          atLevel:(NSInteger)level;
@end


//
// Looger is thread safe in a sense that logging and configuration calls are
// muturally exclusive
//

@interface SYLogger : NSObject 
{         
    NSMutableString* regEx;
    NSMutableArray* delegates;
    NSLock* lock;
}


//
// Thread-safe
//
+(SYLogger*)instance;

//
// Following calls are expected to be called from the "main thread"
// Another way to put it: logger is expected to be configured on main thread
//

-(void)addSilentClassName:(NSString*)classRegEx 
             selectorName:(NSString*)selectorRegEx
                 forLevel:(NSInteger)level;

-(void)clearConfiguration;
-(void)addChannel:(id<SYLoggerChannel>)deleagate;
-(void)removeChannel:(id<SYLoggerChannel>)delegate;
-(void)removeAllChannels;



@end
